﻿using System;
using System.Web;
using System.Configuration;

/// <summary>
/// HTTP module to restrict access by IP address
/// </summary>
public class SecurityHttpModule : IHttpModule
{
    public SecurityHttpModule()
    {
    }

    public void Init(HttpApplication context)
    {
        context.BeginRequest += new EventHandler(Application_BeginRequest);
    }

    private void Application_BeginRequest(object source, EventArgs e)
    {
        HttpContext context = ((HttpApplication)source).Context;

        string ipAddress = context.Request.UserHostAddress;

        if (IsValidIpAddress(ipAddress) == false)
        {
            context.Response.StatusCode = 403;
        }
    }

    private bool IsValidIpAddress(string ipAddress)
    {
        if (ConfigurationManager.AppSettings["accesslist"] != null)
        {
            if (ConfigurationManager.AppSettings["accesslist"].IndexOf(ipAddress) > -1 || ConfigurationManager.AppSettings["accesslist"].Length == 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        else
        {
            return true;
        }
    }

    public void Dispose()
    {
    }
}
